# -*- coding: utf-8 -*-
"""
Created on Thu Mar  2 14:08:49 2023

@author: abesni05
"""

import mysql.connector
import pandas as pd
import numpy as np
import chardet

def detect_phone_number_columns(df):
    """
    Detecte les colonnes contenant des numeros de telephone dans un dataframe.
    """
    phone_number_columns = []
    for column in df.columns:
        # Vérifier si la colonne ne contient que des chaînes de caractères
        if df[column].dtype == 'object':
            # Vérifier si la colonne contient des chiffres et des espaces seulement
            if df[column].str.match(r'^[\d\s]+$').all():
                # Enlever les espaces de la colonne
                df[column] = df[column].str.replace(' ', '')
                phone_number_columns.append(column)
    return phone_number_columns
# Connexion à la base de données
db = mysql.connector.connect(
    host="localhost",
    user="root",
    password="",
    database=input("Entrez le nom de la base de donnée SQL ex: lojuzo : ")
)

# Création du curseur
cursor = db.cursor()

# Lecture du nom du fichier CSV
filename = input("Entrez le nom du fichier CSV ex: 'mon_fichier.csv' : ")

with open(filename, 'rb') as f:
    result = chardet.detect(f.read())
    encodage = result['encoding']
    
# Lecture du fichier CSV
df = pd.read_csv(filename, header=0, delimiter=';', dtype=str, encoding='ISO-8859-1')
df = df.replace({np.nan: None})

if filename == 'panne.csv':
    # Vérifier si la table 'panne' existe déjà dans la base de données
    describe_query = f"DESCRIBE panne"
    cursor.execute(describe_query)
    table_columns = [row[0] for row in cursor.fetchall()]
    if 'noPanne' in table_columns:
        # Récupérer le nombre de tuples dans la table 'panne'
        count_query = f"SELECT COUNT(*) FROM panne"
        cursor.execute(count_query)
        count = cursor.fetchone()[0]

        # Ajouter une colonne d'identifiant à la première position du DataFrame
        df.insert(0, 'id', range(count+1, count+1+len(df)))
    
# Vérification du nombre de colonnes
table_name = filename[:-4]
describe_query = f"DESCRIBE {table_name} "
cursor.execute(describe_query)
table_columns = [row[0] for row in cursor.fetchall()]
for column in cursor.fetchall():
    table_columns.append(column[0])
if len(df.columns) > len(table_columns):
        # Ajouter les autres valeurs des colonnes qui contiennent des valeurs nulles à la dernière colonne formée uniquement de valeurs non nulles
    last_column = df.columns[df.notna().all()].tolist()[-1]
    df[last_column] = df[last_column].fillna('').astype(str)
    right_columns = df.columns[df.columns.get_loc(last_column)+1:] # Récupère les colonnes à droite de last_column
    df[last_column] = df.apply(lambda row: ''.join(row[last_column]+',' if pd.notna(row[last_column]) else '') +
                               ','.join([('' if i>0 else '') + str(row[col]) for i, col in enumerate(df.columns[df.columns.get_loc(last_column):]) if pd.notna(row[col])]), axis=1)
    
# Supprimer les colonnes contenant des valeurs nulles
df = df.dropna(axis=1)
df = df.rename(columns=dict(zip(df.columns, table_columns)))


# Conversion des valeurs numériques en float
numerical_columns = df.select_dtypes(include=['int64', 'float64']).columns
df[numerical_columns] = df[numerical_columns].astype(float)

# Sélection des colonnes de dates
date_columns = df.select_dtypes(include=['datetime64']).columns

# Conversion des valeurs dates sous un format acceptable par MySQL
for col in df.columns:
    if col.startswith('Date') or col.startswith('date'):
        df[col] = pd.to_datetime(df[col], format='%d/%m/%Y').dt.date.astype(str)

# Appel de la fonction detect_phone_number_columns pour détecter les colonnes de numéro de téléphone
phone_columns = detect_phone_number_columns(df)

# Remplacement des numéros de téléphone pour toutes les colonnes et toutes les lignes nécessaires
for col in phone_columns:
    df[col] = df[col].str.replace(' ','')

# Récupération des types de colonnes de la table
table_types = {}
for column in table_columns:
    describe_query = f"DESCRIBE {table_name} {column} "
    cursor.execute(describe_query)
    table_types[column] = cursor.fetchone()[1]

if filename == 'panne.csv':
    # Vérifier si la table 'panne' existe déjà dans la base de données
    describe_query = f"DESCRIBE panne"
    cursor.execute(describe_query)
    table_columns = [row[0] for row in cursor.fetchall()]
    if 'id' in table_columns:
        # Récupérer le nombre de tuples dans la table 'panne'
        count_query = f"SELECT COUNT(*) FROM panne"
        cursor.execute(count_query)
        count = cursor.fetchone()[0]

        # Ajouter une colonne d'identifiant à la première position du DataFrame
        df.insert(0, 'id', range(count+1, count+1+len(df)))
        
# Vérification des contraintes de clés primaires et étrangères
for i, row in df.iterrows():
    try:
        # Vérification des contraintes de clé primaire
        primary_key_query = f"SELECT COUNT(*) FROM {table_name} WHERE {table_columns[0]} = %s"
        cursor.execute(primary_key_query, (row[table_columns[0]],))
        if cursor.fetchone()[0] > 0:
            raise ValueError(f"Il y a un doublon de clé primaire '{row[table_columns[0]]}' dans la table '{table_name}'")
            
    
        # Vérification des contraintes de clé étrangère
        for column in table_columns[1:]:
            # Vérification que la colonne existe dans la table
            describe_query = f"DESCRIBE {table_name} {column}"
            cursor.execute(describe_query)
            column_info = cursor.fetchone()
            if column_info is None:
                raise ValueError(f"La colonne '{column}' n'existe pas dans la table '{table_name}'")
                
    
            # Vérification des contraintes de clé étrangère
            column_type = column_info[1]
            if column_type.startswith("FOREIGN"):
                foreign_key_query = f"SELECT COUNT(*) FROM {column} WHERE {column[:-3]} = %s"
                cursor.execute(foreign_key_query, (row[column],))
                if cursor.fetchone()[0] == 0:
                    raise ValueError(f"La clé étrangère '{row[column]}' de la colonne '{column}' n'existe pas dans sa table d'origine")


        # Insertion de la ligne dans la table
        insert_query = f"INSERT INTO {table_name} ({', '.join(table_columns)}) VALUES ({', '.join(['%s' for _ in table_columns])})"
        values = tuple(row[df.columns.get_loc(df.columns[i])] for i in range(min(len(table_columns), len(df.columns))))
        cursor.execute(insert_query, values)
        db.commit()
        
    except ValueError as e:
        print(f"Erreur lors de l'insertion de la ligne {i+1} : {e}")
        continue
    db.commit()
    
# Sélection des données insérées
select_query = f"SELECT * FROM {table_name}"
cursor.execute(select_query)

# Récupération des données insérées
rows = cursor.fetchall()

# Affichage des données insérées
print("L'insertion est confirmée")
